/* $Revision 1.3 */
/* Copyright Psion Teklogix Inc. 2010-2011 */
/*
 * File: RFIDDriver.h
 *
 * Description:
 *  Header file that contains the definitions to manage the RFID driver.
 *
 */
#ifndef __RFIDDRIVER_H
#define __RFIDDRIVER_H

/**
@brief This is the Psion Teklogix root namespace.  It has no publicly-accessible
members or functions.  All SDK functionality is contained within other
namespaces nested within this one.
*/
namespace Psion
{
	namespace RFID
	{
		class RFIDDriver
		{
			public:
                /**
                 Class constructor. 
                */
				RFIDDriver();
                /**
                 Class constructor. 
				 @param INT - possible values 1, 2 or 3 for the RFIDDevice index to use
                */
				RFIDDriver(int driverNumber);
                /**
                Checks if the RFID driver is well installed
                @return BOOL (true: installed / false: not installed)
                */
				BOOL IsInstalled();
                /**
                Checks if the RFID driver is enabled (powered and com port assigned)
                @return BOOL (true: enabled / false: disabled)
                */
				BOOL IsEnabled();
                /**
                Checks if the RFID driver is enabled (powered and com port assigned)
                @return DWORD > 0 (value of com port assigned)
						DWORD == -1 (driver not installed)
						DWORD == -2 (driver not enabled)
						DWORD == -3 (driver not opened)
						DWORD == -4 (version issue between library and driver)
                */
				DWORD ComPort();

                /**
                Enables RFID driver 
                @return DWORD == 0 (Success)
						DWORD > 0 (refer RFID_ERR in RFIDIOCTL to get error messages)
                */
				DWORD Enable ();
                /**
                Disables RFID driver 
                @return DWORD == 0 (Success)
						DWORD > 0 (refer RFID_ERR in RFIDIOCTL to get error messages)
                */
				DWORD Disable ();

                /**
                Get Driver version 
                @return PTCHAR == Driver version
                */
				PTCHAR GetDriverVersion();
                /**
                Get Library version 
                @return PTCHAR == Library version
                */
				PTCHAR GetLibraryVersion();
                /**
                Get RFID Product Reference
                @return PTCHAR == RFID Product Reference
                */
				PTCHAR GetReference();
                /**
                Get RFID Frequency
                @return PTCHAR == RFID Frequency
                */
				PTCHAR GetFrequency();
                /**
                Get Supplier name
                @return PTCHAR == Supplier name
                */
				PTCHAR GetSupplier();
                /**
                Get RFID module name
                @return PTCHAR == RFID Module Name
                */
				PTCHAR GetModule();

		};
	}
}
#endif // __RFIDDRIVER_H
